//----------------------------------------------------------------------------
//
// Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
//
// Use, modification and distribution are subject to the Boost Software
// License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
//
//----------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIMCAQLib;

namespace SQPCSharpSample
{
   public partial class Form1 : Form
   {
      EzQ ezQ = new EzQ();

      public Form1()
      {
         InitializeComponent();
      }

      private void button1_Click(object sender, EventArgs e)
      {
         if (openFileDialog1.ShowDialog() == DialogResult.OK)
         {
            try
            {
               if (!ezQ.OpenProject(openFileDialog1.FileName, null))
                  throw new System.Exception(ezQ.LastErrorMessage);

               //Use the first model
               ezQ.SelectModel(1);

               // Create a fake prediction-set with the required names plus a few more.
               VariableVector varVec = ((VariableVector)((PreparePrediction)ezQ.Model.PreparePrediction()).GetVariablesForPrediction());
               long lPredictions = varVec.GetSize();
               
               float[] predSet = new float[lPredictions+2];
               String[] Names = new String[lPredictions+2];

               Names[0] = "excluded1";
               predSet[0] = 1.2f;
               Names[1] = "excluded2";
               predSet[1] = 2.3f;

               for (int i = 0; i < lPredictions; ++i)
               {
                   Variable var = (Variable)varVec.GetVariable(i+1);
                   Names[i+2] = var.GetName(1);
                   predSet[i+2] = i;
               }

               ezQ.Predict(predSet, 1, predSet.Length, Names);

               // Output the result
               VectorData result = ezQ.GetDModXPS();
               if (result.GetDataMatrix() != null)
                  lblDModX.Text = String.Format("{0}", ((FloatMatrix)result.GetDataMatrix()).GetData(1, 1));
               result = ezQ.GetT2RangePS();
               if (result.GetDataMatrix() != null)
                  lblHotellings.Text = String.Format("{0}", ((FloatMatrix)result.GetDataMatrix()).GetData(1, 1));

// Predict without checking names (faster but you must be certain the model always have the expected variables)
//                // Create a fake prediction set
//                long lPredictions = ((VariableVector)((PreparePrediction)ezQ.Model.PreparePrediction()).GetVariablesForPrediction()).GetSize();
//                float[] predSet = new float[lPredictions];
//                for (int i = 0; i < predSet.Length; ++i)
//                    predSet[i] = i;
//                ezQ.Predict2(predSet, 1, predSet.Length, null, 0, 0);

                ezQ.CloseProject();
            }
            catch (System.Exception ex)
            {
               MessageBox.Show(String.Format("An error occured while processing the project:\n\n{0}", ex.Message), this.Text);

               lblDModX.Text = "N/A";
               lblHotellings.Text = "N/A";

               ezQ.CloseProject();
            }
         }
      }

      private void button2_Click(object sender, EventArgs e)
      {
         Close();
      }
   }
}